#ToolMemory (c) 2014 Fabian Rosenkranz • www.studio-fabian.de

import c4d
from c4d import gui, bitmaps, documents, plugins
import os, webbrowser

#be sure to use a unique ID obtained from www.plugincafe.com
MENU_PLUGIN_ID = 1028523 


####################################### Notice #################################################################
#Res.h files are not read by Python. So you must add your GUI items, and a numerical ID, to the top of your main .pyp source code



TOOLMEMORY_DIALOG		=10001
GROUP_ACTIVE			=10002
IDC_GROUP_ALL			=10003
IDC_CHECK_STORETOOL		=10004
IDC_CHECK_RESTORETOOL	=10005
IDC_CHECK_STOREMODE		=10006
IDC_CHECK_RESTOREMODE	=10007
IDC_CHECK_STOREAXIS		=10008
IDC_CHECK_RESTOREAXIS	=10009
IDC_STATIC_TOOLINFO		=10010
IDC_CHECK_TOOLFIX		=10011
IDC_STATIC_MODEINFO		=10012
IDC_CHECK_MODEFIX		=10013	
IDC_STATIC_AXISINFOX	=10014
IDC_STATIC_AXISINFOY	=10015
IDC_STATIC_AXISINFOZ	=10016
IDC_CHECK_AXISFIX		=10017

M_INFO_1				=10101
M_INFO_2				=10102
M_HELP					=10103
M_SPECIAL				=10104

########################################################## 

class ToolMemoryDialog(gui.GeDialog):
	 
	bc = c4d.BaseContainer()
	myOp = None
	Lx = True
	Ly = True
	Lz = True
	Overwrite = False


	def CreateLayout(self):
		self.MenuSubBegin("Info") 
    		self.MenuAddString(M_INFO_1, "(c) 2012 by Fabian Rosenkranz") 
    		self.MenuAddString(M_INFO_2, "www.studio-fabian.de") 
  		self.MenuSubEnd()
  		self.MenuSubBegin("Help") 
    		self.MenuAddString(M_HELP, "help...") 
  		self.MenuSubEnd() 
  		self.MenuSubBegin("!!!") 
    		self.MenuAddString(M_SPECIAL, "!!!") 
  		self.MenuSubEnd() 
  		self.MenuFinished() 
		self.LoadDialogResource(TOOLMEMORY_DIALOG)
		return True
		
	def InitValues(self):
		self.SetBool(GROUP_ACTIVE,True)
		self.SetBool(IDC_CHECK_STORETOOL,True)
		self.SetBool(IDC_CHECK_STOREMODE,True)
		self.SetBool(IDC_CHECK_STOREAXIS,True)
		self.SetBool(IDC_CHECK_RESTORETOOL,True)
		self.SetBool(IDC_CHECK_RESTOREMODE,True)
		self.SetBool(IDC_CHECK_RESTOREAXIS,True)
		self.FillContainer()
		return True
		
	def FillContainer(self):
		doc = c4d.documents.GetActiveDocument()
		self.myOp = doc.GetActiveObject()
		op = doc.GetActiveObject()
		#print "Restore Axis: ",self.GetBool(IDC_CHECK_RESTOREAXIS)
		if op and self.GetBool(GROUP_ACTIVE)==True:
			self.Enable(IDC_GROUP_ALL,True)	
			bc = op.GetData()
			if not bc.GetContainer(MENU_PLUGIN_ID):
				#print "no Data"
				my_bc = c4d.BaseContainer()
				if self.GetBool(IDC_CHECK_STORETOOL)==True:
					my_bc.SetLong(10001,doc.GetAction())
				my_bc.SetBool(10011,False)
				self.SetBool(IDC_CHECK_TOOLFIX,False)
				if self.GetBool(IDC_CHECK_STOREMODE)==True:
					my_bc.SetLong(10002,doc.GetMode())
				my_bc.SetBool(10012,False)
				self.SetBool(IDC_CHECK_MODEFIX,False)
				if self.GetBool(IDC_CHECK_STOREAXIS)==True:
					my_bc.SetLong(10003,c4d.IsCommandChecked(12153)+1) # Axis Lock X in editor
					my_bc.SetLong(10004,c4d.IsCommandChecked(12154)+1)
					my_bc.SetLong(10005,c4d.IsCommandChecked(12155)+1)
				my_bc.SetBool(10013,False)
				self.SetBool(IDC_CHECK_AXISFIX,False)
				bc.SetContainer(MENU_PLUGIN_ID,my_bc)	
				op.SetData(bc, add = False)
				op.Message(c4d.MSG_CHANGE)	
			
			elif self.Overwrite == True:
				#print "Overwrite True"
				my_bc = bc.GetContainer(MENU_PLUGIN_ID)
				if self.GetBool(IDC_CHECK_STORETOOL)==True:
					if self.GetBool(IDC_CHECK_TOOLFIX)!=my_bc.GetBool(10011):
						my_bc.SetLong(10001,doc.GetAction())
						my_bc.SetBool(10011,self.GetBool(IDC_CHECK_TOOLFIX))
						#print "Toolfix changed ", my_bc.GetBool(10011)
					elif self.GetBool(IDC_CHECK_TOOLFIX)==False:
						#print "Toolfix off"	
						my_bc.SetLong(10001,doc.GetAction())
				elif self.GetBool(IDC_CHECK_TOOLFIX)!=my_bc.GetBool(10011):						
					my_bc.SetBool(10011,self.GetBool(IDC_CHECK_TOOLFIX))		
				if self.GetBool(IDC_CHECK_STOREMODE)==True:
					if self.GetBool(IDC_CHECK_MODEFIX)!=my_bc.GetBool(10012):
						#print "Modefix Changed"
						my_bc.SetLong(10002,doc.GetMode())
						my_bc.SetBool(10012,self.GetBool(IDC_CHECK_MODEFIX))
					elif self.GetBool(IDC_CHECK_MODEFIX)==False:
						#print "Modefix Off"	
						my_bc.SetLong(10002,doc.GetMode())
				elif self.GetBool(IDC_CHECK_MODEFIX)!=my_bc.GetBool(10012):						
					my_bc.SetBool(10012,self.GetBool(IDC_CHECK_MODEFIX))
				if self.GetBool(IDC_CHECK_STOREAXIS)==True:
					if self.GetBool(IDC_CHECK_AXISFIX)!=my_bc.GetBool(10013):
						#print "Axisfix Changed"
						my_bc.SetLong(10003,c4d.IsCommandChecked(12153)+1)
						my_bc.SetLong(10004,c4d.IsCommandChecked(12154)+1)
						my_bc.SetLong(10005,c4d.IsCommandChecked(12155)+1)
						my_bc.SetBool(10013,self.GetBool(IDC_CHECK_AXISFIX))
					elif self.GetBool(IDC_CHECK_AXISFIX)==False:
						#print "Axisfix Off"	
						my_bc.SetLong(10003,c4d.IsCommandChecked(12153)+1)
						my_bc.SetLong(10004,c4d.IsCommandChecked(12154)+1)
						my_bc.SetLong(10005,c4d.IsCommandChecked(12155)+1)
				elif self.GetBool(IDC_CHECK_AXISFIX)!=my_bc.GetBool(10013):						
					my_bc.SetBool(10013,self.GetBool(IDC_CHECK_AXISFIX))
				bc.SetContainer(MENU_PLUGIN_ID,my_bc)	
				op.SetData(bc, add = False)
				op.Message(c4d.MSG_CHANGE)	
				self.Overwrite = False
				
			else:
				bc = op.GetData()
				my_bc = bc.GetContainer(MENU_PLUGIN_ID)
							
				#print "Restore : Overwrite = False "
				if self.GetBool(IDC_CHECK_RESTORETOOL) == True:
					if my_bc.GetLong(10001) != 0:
						doc.SetAction(my_bc.GetLong(10001))
						#print "TOOL SET!!!"
				self.SetBool(IDC_CHECK_TOOLFIX, my_bc.GetBool(10011))
				if self.GetBool(IDC_CHECK_RESTOREMODE) == True:
					if my_bc.GetLong(10002) != 0:
						doc.SetMode(my_bc.GetLong(10002))
						#print "MODE SET!!!"	
				self.SetBool(IDC_CHECK_MODEFIX, my_bc.GetBool(10012))
				if self.GetBool(IDC_CHECK_RESTOREAXIS) == True:
					#print "restore axis true"
					if my_bc.GetLong(10003) != 0:
						if my_bc.GetLong(10003)-1 != c4d.IsCommandChecked(12153):
							doc[c4d.DOCUMENT_STATEX] = my_bc.GetLong(10003)-1
							#print "XAxis set!!!" 
					if my_bc.GetLong(10004) != 0:
						if my_bc.GetLong(10004)-1 != c4d.IsCommandChecked(12154):
							doc[c4d.DOCUMENT_STATEY] = my_bc.GetLong(10004)-1 
					if my_bc.GetLong(10005) != 0:
						if my_bc.GetLong(10005)-1 != c4d.IsCommandChecked(12155):
							doc[c4d.DOCUMENT_STATEZ] = my_bc.GetLong(10005)-1 
				self.SetBool(IDC_CHECK_AXISFIX, my_bc.GetBool(10013))	
		
		else:		
			#print "no op"
			self.SetBool(IDC_CHECK_TOOLFIX,False)
			self.SetBool(IDC_CHECK_MODEFIX,False)
			self.SetBool(IDC_CHECK_AXISFIX,False)
			self.WriteInfo()
			self.Enable(IDC_GROUP_ALL,False)
			return True
		
				
		self.WriteInfo()
		return True
		
		
		
	def WriteInfo(self):	
		#print "Write Info "
		doc = c4d.documents.GetActiveDocument()
		op = doc.GetActiveObject()
		if not op or self.GetBool(GROUP_ACTIVE)==False:
			self.SetString(IDC_STATIC_TOOLINFO, "(none)")
			self.SetString(IDC_STATIC_MODEINFO, "(none)")
			self.SetString(IDC_STATIC_AXISINFOX, "(-)")	
			self.SetString(IDC_STATIC_AXISINFOY, "(-)")	
			self.SetString(IDC_STATIC_AXISINFOZ, "(-)")	
			return
		bc = op.GetData()
		my_bc = bc.GetContainer(MENU_PLUGIN_ID)		
		
		if my_bc.GetLong(10001) == 0:
			self.SetString(IDC_STATIC_TOOLINFO, "(none)")
		else:
			self.SetString(IDC_STATIC_TOOLINFO, c4d.GetCommandName(my_bc.GetLong(10001)))
			
		if my_bc.GetLong(10002) == 0:
			self.SetString(IDC_STATIC_MODEINFO, "(none)")	
		elif my_bc.GetLong(10002) == c4d.Mcamera:
			self.SetString(IDC_STATIC_MODEINFO, "Camera")
		elif my_bc.GetLong(10002) == c4d.Mobject:
			self.SetString(IDC_STATIC_MODEINFO, "Object")
		elif my_bc.GetLong(10002) == c4d.Mtexture:
			self.SetString(IDC_STATIC_MODEINFO, "Texture")
		elif my_bc.GetLong(10002) == c4d.Mtextureaxis:
			self.SetString(IDC_STATIC_MODEINFO, "Texture Axis")
		elif my_bc.GetLong(10002) == c4d.Mpoints:
			self.SetString(IDC_STATIC_MODEINFO, "Points")
		elif my_bc.GetLong(10002) == c4d.Medges:
			self.SetString(IDC_STATIC_MODEINFO, "Edges")
		elif my_bc.GetLong(10002) == c4d.Mpolygons:
			self.SetString(IDC_STATIC_MODEINFO, "Polygons")
		elif my_bc.GetLong(10002) == c4d.Manimation:
			self.SetString(IDC_STATIC_MODEINFO, "Animation")
		elif my_bc.GetLong(10002) == c4d.Mkinematic:
			self.SetString(IDC_STATIC_MODEINFO, "IK")
		elif my_bc.GetLong(10002) == c4d.Mmodel:
			self.SetString(IDC_STATIC_MODEINFO, "Model")
		elif my_bc.GetLong(10002) == c4d.Mpaint:
			self.SetString(IDC_STATIC_MODEINFO, "Paint")
		elif my_bc.GetLong(10002) == c4d.Muvpoints:
			self.SetString(IDC_STATIC_MODEINFO, "UV Points")
		elif my_bc.GetLong(10002) == c4d.Muvpolygons:
			self.SetString(IDC_STATIC_MODEINFO, "UV Polygons")
		elif my_bc.GetLong(10002) == c4d.Mdrag:
			self.SetString(IDC_STATIC_MODEINFO, "Drag")
		elif my_bc.GetLong(10002) == c4d.Mpolyedgepoint:
			self.SetString(IDC_STATIC_MODEINFO, "Poly/Edge/Point")
		elif my_bc.GetLong(10002) == c4d.Medgepoint:
			self.SetString(IDC_STATIC_MODEINFO, "Edge/Point")
		elif my_bc.GetLong(10002) == c4d.Mworkplane:	
			self.SetString(IDC_STATIC_MODEINFO, "Workplane")
		else:			
			self.SetString(IDC_STATIC_MODEINFO, "Unknown")
			
		if my_bc.GetLong(10003) == 0:
			self.SetString(IDC_STATIC_AXISINFOX, "(-)")	
			self.SetString(IDC_STATIC_AXISINFOY, "(-)")	
			self.SetString(IDC_STATIC_AXISINFOZ, "(-)")
		else:
			self.SetString(IDC_STATIC_AXISINFOX, "X")	
			self.SetString(IDC_STATIC_AXISINFOY, "Y")	
			self.SetString(IDC_STATIC_AXISINFOZ, "Z")
			self.Enable(IDC_STATIC_AXISINFOX,my_bc.GetLong(10003)-1)
			self.Enable(IDC_STATIC_AXISINFOY,my_bc.GetLong(10004)-1)
			self.Enable(IDC_STATIC_AXISINFOZ,my_bc.GetLong(10005)-1)		
		return True

		
	def CoreMessage(self,id,msg):
		##print id
		if self.GetBool(GROUP_ACTIVE)==True:
			if id == c4d.EVMSG_TOOLCHANGED:
				#print "Tool Changed"
				if self.myOp:
					self.Overwrite = True
				self.FillContainer()
			elif id == c4d.EVMSG_CHANGE:
				doc = c4d.documents.GetActiveDocument()
				if self.myOp != doc.GetActiveObject():
					#print "Selection Changed"
					self.FillContainer()
				if self.Lx != c4d.IsCommandChecked(12153) or self.Ly != c4d.IsCommandChecked(12154) or self.Lz != c4d.IsCommandChecked(12155):
					self.Lx = c4d.IsCommandChecked(12153)
					self.Ly = c4d.IsCommandChecked(12154)
					self.Lz = c4d.IsCommandChecked(12155)
					if self.myOp:
						self.Overwrite = True
					self.FillContainer()
		return True
		
	def Command(self,id,msg):
		c4d.StopAllThreads
		if id == M_SPECIAL:
			gui.MessageDialog("This Plugin is Freeware, but if you like it, do something for the environment TODAY!\n\nSince you have access to a computer and fancy software, you are part of the 5% richest\npeople on this planet who are doing almost all the dirt and damage.\n\n• If you make a lot of money, donate some to Greenpeace or a similar organization\n• Ride your bicycle instead of using your car\n• Buy some food or other stuff in your local health food store instead of the supermarket\n• Buy the grey and scratchy toilet paper instead of the soft, white, perfumed stuff\n• Switch off all unused electronic instruments instead of using standby\n\nNot even Cinema 4d can build a new planet when this one is damaged.\nSo PLEASE take some responsibility.\n\nThank you!")
			return True
		elif id == M_HELP:
			dir, file = os.path.split(__file__)
			webbrowser.open(os.path.join(dir,"res","ToolMemory.pdf"	))
			return True
		elif id == M_INFO_1:
			webbrowser.open('http://www.studio-fabian.de')
			return True
		elif id == M_INFO_2:
			webbrowser.open('http://www.studio-fabian.de')
			return True
		elif id == GROUP_ACTIVE:
			self.Enable(IDC_GROUP_ALL, self.GetBool(GROUP_ACTIVE))
			self.FillContainer()
		elif self.GetBool(GROUP_ACTIVE)==True:
			if id == IDC_CHECK_TOOLFIX or id == IDC_CHECK_MODEFIX or id == IDC_CHECK_AXISFIX:
 				self.Overwrite = True			
			self.FillContainer()
		return True
		
		
class ToolMemory(c4d.plugins.CommandData):

	dialog = None

	def Execute(self, doc):
		if self.dialog is None:
			self.dialog = ToolMemoryDialog()

		return self.dialog.Open(c4d.DLG_TYPE_ASYNC, MENU_PLUGIN_ID,270, 100)

	def RestoreLayout(self, sec_ref):
		if self.dialog is None:
			self.dialog = ToolMemoryDialog()

		return self.dialog.Restore(MENU_PLUGIN_ID, sec_ref)


if __name__ == "__main__":
	dir, file = os.path.split(__file__)
	bmp = bitmaps.BaseBitmap()
	bmp.InitWith(os.path.join(dir, "res", "ToolMemory.tif"))
	c4d.plugins.RegisterCommandPlugin(MENU_PLUGIN_ID, "ToolMemory", 0, bmp, "Stores and restores tool and mode used by each object", ToolMemory())	
	print "ToolMemory loaded, (c) Fabian Rosenkranz 2014, www.studio-fabian.de"